@extends('layouts.admin')

@section('title', 'Edit Content')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Content</h1>
    <a href="{{ route('admin.contents.index') }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back to List
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.contents.update', $content) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="mb-3">
                <label for="page_key" class="form-label">Page Key <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('page_key') is-invalid @enderror" id="page_key" name="page_key" value="{{ old('page_key', $content->page_key) }}" required>
                <small class="form-text text-muted">Unique identifier for this content</small>
                @error('page_key')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="section" class="form-label">Section</label>
                <input type="text" class="form-control @error('section') is-invalid @enderror" id="section" name="section" value="{{ old('section', $content->section) }}">
                @error('section')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="label" class="form-label">Label <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('label') is-invalid @enderror" id="label" name="label" value="{{ old('label', $content->label) }}" required>
                @error('label')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="type" class="form-label">Content Type <span class="text-danger">*</span></label>
                <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                    <option value="text" {{ old('type', $content->type) == 'text' ? 'selected' : '' }}>Text</option>
                    <option value="html" {{ old('type', $content->type) == 'html' ? 'selected' : '' }}>HTML</option>
                    <option value="image" {{ old('type', $content->type) == 'image' ? 'selected' : '' }}>Image URL</option>
                </select>
                @error('type')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="content" class="form-label">Content</label>
                <textarea class="form-control @error('content') is-invalid @enderror" id="content" name="content" rows="8">{{ old('content', $content->content) }}</textarea>
                @error('content')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle"></i> Update Content
                </button>
                <a href="{{ route('admin.contents.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection



